package cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.DuibaJvmMonitorProperties;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JvmAlertComponent;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Map;

public class YGCTAlerter extends GcAlerter {

    @Resource
    private DuibaJvmMonitorProperties duibaJvmMonitorProperties;

    @Resource
    private JvmAlertComponent jvmAlertComponent;

    @Override
    public Map<Integer, Integer> getRule() {
        return duibaJvmMonitorProperties.getYgctRule();
    }

    @Override
    public int compute(Pair<JstatPoint, JstatPoint> pointPair) {
        JstatPoint left = pointPair.getLeft();
        JstatPoint right = pointPair.getRight();
        return right.getYgct() - left.getYgct();
    }

    @Override
    public void alert(int ruleMinutes, int ruleValue, int currentValue) {
        String ruleValueStr = new BigDecimal(ruleValue).divide(JstatPoint.MULTIPLE, 3, BigDecimal.ROUND_HALF_UP).toString();
        String currentValueStr = new BigDecimal(currentValue).divide(JstatPoint.MULTIPLE, 3, BigDecimal.ROUND_HALF_UP).toString();
        jvmAlertComponent.doAlert(ruleMinutes, ruleValueStr + "秒", currentValueStr + "秒", "YGCT过长");
    }

}
