package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.web.csp.CspReportReactiveFilter;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 给web应用自动配置csp上报url，当前端csp规则发现被阻止的情况时会主动调用http://localhost:${port}/csp/report上报，上报后打印日志到主日志文件中
 */
@Configuration
@AutoConfigureAfter({WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value = "duiba.server.internal-mode", havingValue = "false", matchIfMissing = true)
public class WebMvcCspReportAutoConfiguration {

    /**
     * 为了防止被应用内的LoginFilter登录拦截器拦截而跳转302，使用Filter
     */
    @Configuration
    @ConditionalOnProperty(value = "duiba.server.internal-mode", havingValue = "false", matchIfMissing = true)
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    public static class CspReportFilterConfiguration{
        @Bean
        public FilterRegistrationBean cspReportFilterConfigurer(){
            CspReportFilter filter=new CspReportFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(filter);
            List<String> urlPatterns=new ArrayList<>();
            urlPatterns.add("/csp/report");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE + 10);//最高优先级
            return registrationBean;
        }
    }

    /**
     * 为了防止被应用内的LoginFilter登录拦截器拦截而跳转302，使用Filter
     */
    @Configuration
    @ConditionalOnProperty(value = "duiba.server.internal-mode", havingValue = "false", matchIfMissing = true)
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
    public static class CspReportReactiveFilterConfiguration{
        @Bean
        @Order(Ordered.HIGHEST_PRECEDENCE + 10)//最高优先级
        public CspReportReactiveFilter cspReportReactiveFilter(){
            return new CspReportReactiveFilter();
        }
    }


//    /**
//     * 附加logback配置文件
//     * @return
//     */
//    @Configuration
//    @ConditionalOnProperty(value = "duiba.server.internal-mode", havingValue = "false", matchIfMissing = true)
//    public static class CspReportLogbackConfigApplicationListener implements ApplicationListener<ContextRefreshedEvent> {
//        private boolean flag = true;
//
//        @Override
//        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
//            if(flag){
//                try {
//                    LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
//                    JoranConfigurator configurator = new JoranConfigurator();
//                    configurator.setContext(loggerContext);
//                    //logback 添加新的配置文件
//                    configurator.doConfigure(new ClassPathResource("/logback/csp-report-logback.xml").getInputStream());
//                } catch (Exception e) {
//                    logger.error(e.getMessage(), e);
//                }
//                flag = false;
//            }
//        }
//    }

    public static class CspReportFilter implements Filter {

        private static final Logger cspReportLogger = LoggerFactory.getLogger("duibaCspReportLog");

        @Override
        public void init(FilterConfig filterConfig) {
            //do nothing
        }

        @Override
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            if(cspReportLogger.isInfoEnabled()) {
                String uri = RequestUtils.getRequestPath(request);
                if (uri.equals("/csp/report") && request.getMethod().equalsIgnoreCase("POST")) {
                    String json = IOUtils.toString(request.getInputStream());
                    cspReportLogger.info(json);
                }
            }
        }

        @Override
        public void destroy() {
            //do nothing
        }

    }
}
