package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

import java.util.*;

/**
 * Created by wenqi.huang on 2017/6/16.
 */
public class BeanPostProcessorOfSpecified implements BeanPostProcessor, ApplicationContextAware, Ordered {

    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap = new HashMap<>(10);
    private List<SpecifiedBeanPostProcessor> processorList;
    private List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList;

    @Override
    public int getOrder() {
        return -2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessBeforeInitialization(bean, beanName);
            }
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for(SpecifiedBeanPostProcessor p : processorList){
            if(p.getBeanType().isAssignableFrom(bean.getClass())){
                bean = p.postProcessAfterInitialization(bean, beanName);
            }
        }

        //生成需要被异步处理的map,方便后续被异步处理
        for(AsyncSpecifiedBeanPostProcessor asyncProcessor : asyncProcessorList){
            if(asyncProcessor.getBeanType().isAssignableFrom(bean.getClass())){
                Map<String, Object> beanMap = asyncProcessor2BeansMap.get(asyncProcessor);
                if(beanMap == null){
                    beanMap = new HashMap<>();
                    asyncProcessor2BeansMap.put(asyncProcessor, beanMap);
                }
                beanMap.put(beanName, bean);
            }
        }

        return bean;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        //找到所有SpecifiedBeanPostProcessor实例并排序，然后在BeanPostProcessor中按顺序处理
        Map<String,SpecifiedBeanPostProcessor> processorMap = applicationContext.getBeansOfType(SpecifiedBeanPostProcessor.class, false, false);
        List<SpecifiedBeanPostProcessor> processorList = new ArrayList<>(processorMap.values());
        Collections.sort(processorList, (o1, o2) -> o1.getOrder() - o2.getOrder());

        //找到所有AsyncSpecifiedBeanPostProcessor实例
        Map<String, AsyncSpecifiedBeanPostProcessor> asyncProcessorMap = applicationContext.getBeansOfType(AsyncSpecifiedBeanPostProcessor.class, false, false);
        List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList = new ArrayList<>(asyncProcessorMap.values());

        this.processorList = processorList;
        this.asyncProcessorList = asyncProcessorList;
    }

    public Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> getAsyncProcessor2BeansMap(){
        return asyncProcessor2BeansMap;
    }
}
