package cn.com.duibaboot.ext.autoconfigure.web.container;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * 存放servlet容器线程池的持有类
 */
public class EmbeddedServletContainerThreadPoolHolder {
    public static enum ServletContainerType{
        TOMCAT, UNDERTOW, JETTY;
    }

    private EmbeddedServletContainerThreadPoolHolder(){}

    /**
     * servlet容器的线程池
     */
    private static volatile ThreadPoolExecutor servletContainerThreadPool;

    private static volatile ServletContainerType servletContainerType;

    public static ServletContainerType getServletContainerType() {
        return servletContainerType;
    }

    protected static void setServletContainerType(ServletContainerType servletContainerType) {
        EmbeddedServletContainerThreadPoolHolder.servletContainerType = servletContainerType;
    }

    /**
     * 设置servlet容器的线程池，只应该在ext内部调用
     * @param servletContainerThreadPool
     */
    protected static void setServletContainerThreadPool(ThreadPoolExecutor servletContainerThreadPool){
        EmbeddedServletContainerThreadPoolHolder.servletContainerThreadPool = servletContainerThreadPool;
    }

    /**
     * 获取servlet容器的线程池
     *
     * @return
     */
    public static ThreadPoolExecutor getServletContainerThreadPool() {
        return servletContainerThreadPool;
    }
}
