package cn.com.duibaboot.ext.autoconfigure.core;

/**
 * 描述: 延迟异步执行某些特殊自定义bean的后置操作
 * <p>
 * 1.和SpecifiedBeanPostProcessor的区别是这个本处理器是异步执行的，但是仍然需要等所有处理器都执行成功了才会让spring启动成功;
 * 2.本处理器不能改变bean的引用;
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/8/12 09:40
 */
public interface DuibaSpecifiedBeanPostProcessor<T> {

    /**
     * 需要处理的Bean类
     *
     * @return
     */
    Class<T> getBeanType();

    void postProcessAfterInitialization(T bean, String beanName);

}
