package cn.com.duibaboot.ext.autoconfigure.core.utils;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

/**
 * 配置解析工具
 * @author liuyao
 */
public class PropertyResolver {

    private final String prefix;

    private final Environment environment;

    public PropertyResolver(Environment environment, String prefix) {
        this.environment = environment;
        this.prefix = prefix;
    }

    /**
     * 将配置绑定到对象中
     */
    public <T> T bindToConfig(Class<T> configClass){
        return Binder.get(environment).bindOrCreate(prefix, configClass);
    }



}
