package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.Jedis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 注入额外的RedisTemplate
 */
//也可以用BeanDefinitionRegistryPostProcessor来注入BeanDefinition
@ConditionalOnClass({ GenericObjectPool.class, JedisConnection.class, Jedis.class })
public class ExtraRedisTemplateImportBeanDefinitionRegistrar4Jedis implements ImportBeanDefinitionRegistrar, EnvironmentAware {

    private List<String> extraRedisTemplateIdsPrefix = new ArrayList<>();

    private static final String JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME = "destroy";

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        for(String extraRedisTemplateIdPrefix : extraRedisTemplateIdsPrefix) {
            String redisConnectionFactoryBeanId = extraRedisTemplateIdPrefix + "RedisConnectionFactory";
            if(registry.containsBeanDefinition(redisConnectionFactoryBeanId)){
                //已经被ExtraRedisTemplateImportBeanDefinitionRegistrar4Lettuce注册过，跳过
                break;
            }
            BeanDefinition extraRedisConnectionFactoryDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(JedisConnectionFactoryBean.class)
//                    .setScope(RefreshAutoConfiguration.REFRESH_SCOPE_NAME)
                    .setDestroyMethodName(JEDIS_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME)
                    .addConstructorArgValue(extraRedisTemplateIdPrefix)
                    .getBeanDefinition();
            registry.registerBeanDefinition(redisConnectionFactoryBeanId, extraRedisConnectionFactoryDefinition);
//            BeanDefinitionHolder extraRedisConnectionFactoryDefinitionHolder = new BeanDefinitionHolder(extraRedisConnectionFactoryDefinition, redisConnectionFactoryBeanId);
//            extraRedisConnectionFactoryDefinitionHolder = ScopedProxyUtils.createScopedProxy(extraRedisConnectionFactoryDefinitionHolder, registry, true);
//            BeanDefinitionReaderUtils.registerBeanDefinition(extraRedisConnectionFactoryDefinitionHolder, registry);

            String extRedisTemplateBeanName = extraRedisTemplateIdPrefix + "RedisTemplate";
            BeanDefinition extraRedisTemplateDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(RedisTemplate.class)
//                    .setScope(RefreshAutoConfiguration.REFRESH_SCOPE_NAME)
                    .addPropertyReference("connectionFactory", redisConnectionFactoryBeanId)
                    //使用hession2序列化方式，提高性能，减少占用redis的空间
                    .addPropertyValue("defaultSerializer", new Hessian2SerializationRedisSerializer())
                    .getBeanDefinition();
            registry.registerBeanDefinition(extRedisTemplateBeanName, extraRedisTemplateDefinition);
//            BeanDefinitionHolder extraRedisTemplateDefinitionHolder = new BeanDefinitionHolder(extraRedisTemplateDefinition, extRedisTemplateBeanName);
//            extraRedisTemplateDefinitionHolder = ScopedProxyUtils.createScopedProxy(extraRedisTemplateDefinitionHolder, registry, true);
//            BeanDefinitionReaderUtils.registerBeanDefinition(extraRedisTemplateDefinitionHolder, registry);

            String extStringRedisTemplateBeanName = extraRedisTemplateIdPrefix + "StringRedisTemplate";
            BeanDefinition extraStringRedisTemplateDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(StringRedisTemplate.class)
//                    .setScope(RefreshAutoConfiguration.REFRESH_SCOPE_NAME)
                    .addPropertyReference("connectionFactory", redisConnectionFactoryBeanId)
                    .getBeanDefinition();
            registry.registerBeanDefinition(extStringRedisTemplateBeanName, extraStringRedisTemplateDefinition);
//            BeanDefinitionHolder extraStringRedisTemplateDefinitionHolder = new BeanDefinitionHolder(extraStringRedisTemplateDefinition, extStringRedisTemplateBeanName);
//            extraStringRedisTemplateDefinitionHolder = ScopedProxyUtils.createScopedProxy(extraStringRedisTemplateDefinitionHolder, registry, true);
//            BeanDefinitionReaderUtils.registerBeanDefinition(extraStringRedisTemplateDefinitionHolder, registry);
        }
    }

    @Override
    public void setEnvironment(Environment environment) {
        String redisExtraIdPrefix = "duiba.redis.extra.";
        String redisExtraIdSuffix = ".host";
        String redisExtraIdSentinelSuffix = ".sentinel.master";
        String redisExtraIdClusterSuffix = ".cluster.nodes";
        LinkedHashMap<String, Object> props = SpringEnvironmentUtils.getFlatEnvironments(environment);
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(redisExtraIdPrefix)) {
                continue;
            }
            int prefixLength = redisExtraIdPrefix.length();
            if (entry.getKey().endsWith(redisExtraIdSuffix)) {
                extraRedisTemplateIdsPrefix.add(entry.getKey().substring(prefixLength, entry.getKey().length() - redisExtraIdSuffix.length()));
            } else if (entry.getKey().endsWith(redisExtraIdSentinelSuffix)) {
                extraRedisTemplateIdsPrefix.add(entry.getKey().substring(prefixLength, entry.getKey().length() - redisExtraIdSentinelSuffix.length()));
            } else if (entry.getKey().endsWith(redisExtraIdClusterSuffix)) {
                extraRedisTemplateIdsPrefix.add(entry.getKey().substring(prefixLength, entry.getKey().length() - redisExtraIdClusterSuffix.length()));
            }
        }
    }

}
