package cn.com.duibaboot.ext.autoconfigure.httpclient;

import org.apache.http.client.HttpClient;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * 自定义RestTemplate，让restTemplate底层使用httpClient
 */
public class DuibaRestTemplateCustomizer implements RestTemplateCustomizer {

    @Resource
    private HttpClient apacheHttpClient;

    @Override
    public void customize(RestTemplate restTemplate) {
        restTemplate.setRequestFactory(new HttpComponentsClientHttpRequestFactory(apacheHttpClient){
            @Override
            public void destroy() throws Exception {
                //父类的destroy会销毁httpClient，然后这个httpClient我们需要自己销毁
            }
        });
    }
}
