package cn.com.duibaboot.ext.autoconfigure.perftest.jest;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.*;
import static net.bytebuddy.matcher.ElementMatchers.*;

/**
 * Jest支持压测，修改index，加上前缀perf__
 */
public class JestMultiInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "io.searchbox.action.AbstractMultiIndexActionBuilder";
    private static final String METHOD_INTERCEPT_CLASS = JestMultiMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
//        return byHierarchyMatch(new String[]{ENHANCE_CLASS});
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return named("addIndex").or(named("addIndices"));
                }

                @Override
                public String getMethodsInterceptor() {
                    return METHOD_INTERCEPT_CLASS;
                }

                @Override public boolean isOverrideArgs() {
                    return true;
                }
            }
        };
    }
}
