package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

/**
 * Monitor拦截器,reactive版, 提供/monitor/start,/monitor/stop,/monitor/check三个url
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class BootMonitorCheckReactiveFilter implements WebFilter {
    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String requestPath = request.getPath().pathWithinApplication().value();
        if(requestPath.equals("/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            if(!ServerStatusHolder.isInService()){
                exchange.getResponse().setStatusCode(HttpStatus.SERVICE_UNAVAILABLE);
            }

            return ReactiveHttpRequestUtils.write(exchange.getResponse(), ServerStatusHolder.isInService() ? "OK" : "INVALID");
        }else if(requestPath.equals("/monitor/stop")){//让check接口返回INVALID
            if(!ReactiveHttpRequestUtils.isLocalRequest(request)){
                return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
            }
            ServerStatusHolder.setInService(false);
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
        }else if(requestPath.equals("/monitor/start")){// 让check接口返回OK
            if(!ReactiveHttpRequestUtils.isLocalRequest(request)){
                return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
            }
            ServerStatusHolder.setInService(true);
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
        }

        return chain.filter(exchange);
    }

}
