package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.web.container.SpecifiedEmbeddedServletContainerCustomizer;

import javax.servlet.*;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;

/**
 * FailFastFilter，判断当前http线程在 httpFailFastExecutor（线程名前缀为HttpFailFastThread）中执行时，直接抛出RejectedExecutionException
 * ，以让HTTP Rest RPC客户端尽快到其他客户端安全地重试。
 */
public class FailFastFilter implements Filter {

    public static final String SERVER_IS_BUSY_NOW = "server is busy now";

    @Override
    public void init(FilterConfig filterConfig) {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        //判断线程名前缀符合，则认为在httpFailFastExecutor中执行，直接抛出异常。（在这之前已经有另一个线程把当前任务从http主线程池移除并转移到了这个线程池中）
        if(Thread.currentThread().getName().startsWith(
                SpecifiedEmbeddedServletContainerCustomizer.HTTP_FAIL_FAST_THREAD_NAME_PREFIX)){
            //client can retry safely without any impact
            throw new RejectedExecutionException(SERVER_IS_BUSY_NOW);
        }else{
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        //do nothing
    }
}
