package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

import java.util.Set;

@Configuration
@ConditionalOnClass(Hystrix.class)
public class HystrixAutoConfiguration {

    //这里暂时没用，这个类实际上是被hystrix使用spi引入的（spring Security中会被拿到进行包装）
    @Bean
    public HystrixConcurrencyStrategy getHystrixConcurrencyStrategy(){
        return new CustomHystrixConcurrencyStrategy();
    }

    /**
     * 初始化Hystrix（进行一次Hystrix调用）。以防止启动后第一次调用很慢的问题。
     * @return
     */
    @Bean
    public ApplicationListener<ContextRefreshedEvent> hystrixInitListener(){
        return new ApplicationListener<ContextRefreshedEvent>() {
            @Override
            public void onApplicationEvent(ContextRefreshedEvent event) {
                if(event.getApplicationContext() instanceof WebApplicationContext
                        || event.getApplicationContext() instanceof ReactiveWebApplicationContext) {//只在主ApplicationContext中运行
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    if(!enabledFeignClientNames.isEmpty()){
//                        String anyfeignClientName = enabledFeignClientNames.iterator().next();
                        String anyfeignClientName = "bootInit";
                        HystrixCommand<String> command = new HystrixCommand<String>(HystrixCommand.Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey(anyfeignClientName))
                                .andCommandKey(HystrixCommandKey.Factory.asKey("bootInit"))) {
                            @Override
                            protected String run() throws Exception {
                                //do nothing
                                return null;
                            }
                        };
                        command.execute();
                    }
                }
            }
        };
    }

    /**
     * 这个类用于修复/hystrix.stream的bug：https://github.com/Netflix/Hystrix/issues/1756
     * <br/>
     * 对HttpServletResponse.PrintWriter的方法进行aop,从而进行必要的同步保护,以修复HystrixSampleSseServlet多线程往writer中写导致tomcat出错的问题。
     * <br/>
     * 等官方修复这个bug后可以去掉这个类。
     */
    @Bean
    public static HystrixStreamEndpointPostProcessor hystrixStreamEndpointPostProcessor(){
        return new HystrixStreamEndpointPostProcessor();
    }
}
