package cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper;

import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ScheduledThreadPoolProperties;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import org.springframework.context.SmartLifecycle;

import java.util.concurrent.*;

/**
 * {@link TransmittableThreadLocal} Wrapper of {@link ScheduledExecutorService},
 * transmit the {@link TransmittableThreadLocal} from the task submit time of {@link Runnable} or {@link Callable}
 * to the execution time of {@link Runnable} or {@link Callable}.
 *
 * @author Jerry Lee (oldratlee at gmail dot com)
 * @since 0.9.0
 */
public class ScheduledThreadPoolExecutorWrapper extends ThreadPoolExecutorWrapper implements ScheduledExecutorService, SmartLifecycle {

    public ScheduledThreadPoolExecutorWrapper(ScheduledThreadPoolProperties poolProperties) {
        super(ScheduledThreadPoolProperties.DEFAULT_SCHEDULED_BEAN_NAME, poolProperties);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().schedule(TtlRunnable.get(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().schedule(TtlCallable.get(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().scheduleAtFixedRate(TtlRunnable.get(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().scheduleWithFixedDelay(TtlRunnable.get(command), initialDelay, delay, unit);
    }

    private ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return (ScheduledThreadPoolExecutor) getInnerThreadPoolExecutor();
    }

}
