package cn.com.duibaboot.ext.autoconfigure.dbexec;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by guoyanfei .
 * 2021/6/3 .
 */
@RestControllerEndpoint(id = "async-profiler")
public class AsyncProfilerEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProfilerEndpoint.class);

    private static final String PROFILER_FILE_PATH = "/tmp/%s-%s-profiler.html";

    private static final ExecutorService es =  new ThreadPoolExecutor(5, 5,
                                                                      0L, TimeUnit.MILLISECONDS,
                                                                      new SynchronousQueue<>(), new NamedThreadFactory("async-profiler"));

    @Resource
    private DuibaExtExecProperties duibaExtExecProperties;

    @RequestMapping(method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE }, value = "/{event}")
    public String invoke(@PathVariable String event) {
        File profilerShFile = new File(duibaExtExecProperties.getAsyncProfilerCommand());
        if (!profilerShFile.exists()) {
            throw new RuntimeException("当前实例暂不支持调用async-profiler, 请将基础镜像修改成【harbor.dui88.com/library/duiba-jdk8:v1.0】");
        }
        if (StringUtils.isBlank(event)) {
            throw new RuntimeException("event 不能为 null");
        }
        AsyncProfilerCommand asyncProfilerCommand = AsyncProfilerCommand.get(event);
        if (asyncProfilerCommand == null) {
            throw new RuntimeException("非法的 event");
        }
        return exec(asyncProfilerCommand);
    }

    private String exec(AsyncProfilerCommand asyncProfilerCommand) {
        String profilerFilePath = String.format(PROFILER_FILE_PATH, System.currentTimeMillis(), asyncProfilerCommand.getCommandKey());
        String command = String.format(asyncProfilerCommand.getCommand(), duibaExtExecProperties.getAsyncProfilerCommand(), profilerFilePath, JvmIdTool.getVmId());
        es.submit(() -> {
            try {
                Runtime.getRuntime().exec(command);
            } catch (IOException e) {
                LOGGER.error("async-profiler exec error, command={}", command, e);
            }
        });
        return profilerFilePath;
    }

}
