package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import java.math.BigDecimal;

/**
 * jstat计数点
 * Created by guoyanfei .
 * 2021/6/9 .
 */
public class JstatPoint {

    public static final BigDecimal MULTIPLE = new BigDecimal(1000);

    private int fgc;

    /**
     * 单位ms
     */
    private int fgct;

    private int ygc;

    /**
     * 单位ms
     */
    private int ygct;

    public JstatPoint() {
    }

    public JstatPoint(String fgc, String fgct, String ygc, String ygct) {
        this.fgc = Integer.parseInt(fgc);
        this.fgct = new BigDecimal(fgct).multiply(MULTIPLE).intValue();
        this.ygc = Integer.parseInt(ygc);
        this.ygct = new BigDecimal(ygct).multiply(MULTIPLE).intValue();
    }

    public int getFgc() {
        return fgc;
    }

    public void setFgc(int fgc) {
        this.fgc = fgc;
    }

    public int getFgct() {
        return fgct;
    }

    public void setFgct(int fgct) {
        this.fgct = fgct;
    }

    public int getYgc() {
        return ygc;
    }

    public void setYgc(int ygc) {
        this.ygc = ygc;
    }

    public int getYgct() {
        return ygct;
    }

    public void setYgct(int ygct) {
        this.ygct = ygct;
    }
}
