package cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import org.apache.commons.lang3.tuple.Pair;

import java.util.LinkedList;
import java.util.Map;

/**
 * gc告警
 * Created by guoyanfei .
 * 2021/6/10 .
 */
public abstract class GcAlerter {

    /**
     * 获取规则
     *
     * @return
     */
    public abstract Map<Integer, Integer> getRule();

    /**
     * 计算告警因子
     *
     * @param pointPair
     * @return
     */
    public abstract int compute(Pair<JstatPoint, JstatPoint> pointPair);

    /**
     * 告警
     *
     * @param ruleMinutes
     * @param ruleValue
     * @param currentValue
     */
    public abstract void alert(int ruleMinutes, int ruleValue, int currentValue);

    public void run(LinkedList<JstatPoint> pointQueue) {
        Map<Integer, Integer> rule = this.getRule();
        for (Map.Entry<Integer, Integer> entry : rule.entrySet()) {
            int ruleMinutes = entry.getKey();
            Pair<JstatPoint, JstatPoint> pointPair = this.getPointPair(pointQueue, ruleMinutes);
            if (pointPair == null) {
                continue;
            }
            int currentValue = this.compute(pointPair);
            if (currentValue > entry.getValue()) {
                this.alert(ruleMinutes, entry.getValue(), currentValue);
            }
        }
    }

    /**
     * 获取倒数第(N+1)个点和最后一个点，表示最近N分钟的前后两个点
     *
     * @param jstatPointQueue
     * @param n
     * @return
     */
    private Pair<JstatPoint, JstatPoint> getPointPair(LinkedList<JstatPoint> pointQueue, int n) {
        if (pointQueue == null || pointQueue.size() < 2) {
            return null;
        }
        int start = pointQueue.size() - (n + 1);
        if (start < 0) {
            start = 0;
        }
        return Pair.of(pointQueue.get(start), pointQueue.getLast());
    }

}
