/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class SpringBootUtils {
    private static final Set<String> SKIPPED_STACK_ELEMENTS;

    private SpringBootUtils() {
    }

    public static boolean isJarInJarMode() {
        Class<?> restartClassLoaderClass = null;
        try {
            restartClassLoaderClass = Class.forName("org.springframework.boot.devtools.restart.classloader.RestartClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Class<?> jarLauncherClass = null;
        try {
            jarLauncherClass = Class.forName("org.springframework.boot.loader.JarLauncher");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return jarLauncherClass != null && SpringBootUtils.class.getClassLoader() != ClassLoader.getSystemClassLoader() && SpringBootUtils.class.getClassLoader().getClass() != restartClassLoaderClass;
    }

    public static boolean isUnitTestMode() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!SpringBootUtils.isSkippedStackElement(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSkippedStackElement(StackTraceElement element) {
        for (String skipped : SKIPPED_STACK_ELEMENTS) {
            if (!element.getClassName().startsWith(skipped)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        skipped.add("org.junit.runners.");
        skipped.add("org.springframework.boot.test.");
        skipped.add("cucumber.runtime.");
        SKIPPED_STACK_ELEMENTS = Collections.unmodifiableSet(skipped);
    }
}

