/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duibaboot.ext.autoconfigure.data.redis.LettuceConnectionConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

public class LettuceConnectionFactoryBean
implements FactoryBean<LettuceConnectionFactory> {
    @Resource
    private RedisProperties redisProperties;
    @Resource
    ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration;
    @Resource
    ObjectProvider<RedisClusterConfiguration> clusterConfiguration;
    @Resource
    ObjectProvider<List<LettuceClientConfigurationBuilderCustomizer>> builderCustomizers;
    private String extraRedisTemplateIdPrefix;
    private LettuceConnectionFactory lettuceConnectionFactory;
    private DefaultClientResources clientResources;

    public LettuceConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
        this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
    }

    private RedisProperties getRedisProperties() {
        if (this.extraRedisTemplateIdPrefix == null) {
            return this.redisProperties;
        }
        return this.redisProperties.getExtra().get(this.extraRedisTemplateIdPrefix);
    }

    @PostConstruct
    public void init() {
        this.clientResources = DefaultClientResources.create();
        LettuceConnectionConfiguration fc = new LettuceConnectionConfiguration(this.getRedisProperties(), this.sentinelConfiguration, this.clusterConfiguration, this.builderCustomizers);
        LettuceConnectionFactory f = fc.redisConnectionFactory((ClientResources)this.clientResources);
        f.afterPropertiesSet();
        this.lettuceConnectionFactory = f;
    }

    public LettuceConnectionFactory getObject() throws Exception {
        return this.lettuceConnectionFactory;
    }

    public Class<?> getObjectType() {
        return LettuceConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.lettuceConnectionFactory != null) {
            this.lettuceConnectionFactory.destroy();
        }
        if (this.clientResources != null) {
            this.clientResources.shutdown().get();
        }
    }
}

