/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RunEnvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class LoggerEnvironmentApplicationInitializer
implements EnvironmentPostProcessor {
    private static final String LOGGER_PATH_KEY = "logging.file.path";

    private boolean isProdEnv(ConfigurableEnvironment environment) {
        String[] activeProfiles;
        for (String p : activeProfiles = environment.getActiveProfiles()) {
            if (p == null || !p.startsWith("prod")) continue;
            return true;
        }
        return false;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String appName = environment.getProperty("spring.application.name", "application");
        String userHome = environment.getProperty("user.home");
        ArrayList pathList = Lists.newArrayList((Object[])new String[]{userHome, "logs", appName});
        if (RunEnvUtils.isRunInDocker() && this.isProdEnv(environment) || "true".equals(environment.getProperty("duiba.logger.path.append.ip", "false"))) {
            pathList.add(NetUtils.getLocalIp());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LOGGER_PATH_KEY, String.join((CharSequence)"/", pathList));
        MapPropertySource propertySource = new MapPropertySource("loggingConfig", map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst((PropertySource)propertySource);
    }
}

