/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class PerfTestFootMarker {
    private static final Logger log = LoggerFactory.getLogger(PerfTestFootMarker.class);
    private static final String PERF_TEST_PREFIX = "/perftest/{sceneId}/";
    private static final String PERF_TEST_APPS_FOOT_KEY = "/perftest/{sceneId}/apps/{appName}";
    private static final String PERF_TEST_DB_FOOT_KEY = "/perftest/{sceneId}/dbUrl/{url}";
    private static final String PERF_TEST_REDIS_FOOT_KEY = "/perftest/{sceneId}/redisUrl/{url}";
    private static final String SCENE_ID_PLACEHOLDER = "{sceneId}";
    private static final String APP_NAME_PLACEHOLDER = "{appName}";
    private static final String URL_PLACEHOLDER = "{url}";
    private static final String PERF_TEST_FOOT_VALUE = "default";
    @Value(value="${spring.application.name}")
    private String currentAppName;
    private final EtcdKVClientDelegate etcdKVClientDelegate;
    private LoadingCache<String, AtomicBoolean> puttingFlagCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).initialCapacity(5).maximumSize(100L).build(key -> new AtomicBoolean(false));
    private Cache<String, String> perfTestFootMarkerCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).initialCapacity(5).maximumSize(100L).build();

    private AtomicBoolean getPuttingFlag(String key) {
        return (AtomicBoolean)this.puttingFlagCache.get((Object)key);
    }

    private String getCache(String key) {
        String value = null;
        try {
            value = (String)this.perfTestFootMarkerCache.get((Object)key, k -> this.etcdKVClientDelegate.get(key));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u538b\u6d4b\u8db3\u8ff9\u5f02\u5e38\uff0ckey={}", (Object)key, (Object)e);
        }
        return value;
    }

    private void putCache(String key, String value) {
        try {
            this.etcdKVClientDelegate.put(key, value);
            this.perfTestFootMarkerCache.put((Object)key, (Object)value);
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u538b\u6d4b\u8db3\u8ff9\u5f02\u5e38\uff0ckey={}", (Object)key, (Object)e);
        }
    }

    public PerfTestFootMarker(EtcdKVClientDelegate etcdKVClientDelegate) {
        this.etcdKVClientDelegate = etcdKVClientDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mark(String halfKey) {
        String sceneId = InternalPerfTestContext.getCurrentSceneId();
        if (sceneId == null) {
            return;
        }
        String key = halfKey.replace(SCENE_ID_PLACEHOLDER, sceneId);
        String value = (String)this.perfTestFootMarkerCache.getIfPresent((Object)key);
        if (StringUtils.isNotBlank((String)value)) {
            return;
        }
        AtomicBoolean putting = this.getPuttingFlag(key);
        if (putting == null) {
            log.warn("getPuttingFlag error, key={}", (Object)key);
            return;
        }
        if (putting.compareAndSet(false, true)) {
            try {
                value = this.getCache(key);
                if (StringUtils.isBlank((String)value)) {
                    value = PERF_TEST_FOOT_VALUE;
                    this.putCache(key, value);
                }
            }
            finally {
                putting.set(false);
            }
        }
    }

    public void markApp() {
        if (!InternalPerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        if (StringUtils.isBlank((String)this.currentAppName)) {
            return;
        }
        this.mark(PERF_TEST_APPS_FOOT_KEY.replace(APP_NAME_PLACEHOLDER, this.currentAppName));
    }

    public void markDb(String url) {
        if (!InternalPerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        if (StringUtils.isBlank((String)url)) {
            return;
        }
        this.mark(PERF_TEST_DB_FOOT_KEY.replace(URL_PLACEHOLDER, url));
    }

    public void markRedis(String url) {
        if (!InternalPerfTestContext.isCurrentInPerfTestMode()) {
            return;
        }
        if (StringUtils.isBlank((String)url)) {
            return;
        }
        this.mark(PERF_TEST_REDIS_FOOT_KEY.replace(URL_PLACEHOLDER, url));
    }

    public void removeMark(String sceneId) {
        if (StringUtils.isBlank((String)sceneId)) {
            return;
        }
        try {
            String prefix = PERF_TEST_PREFIX.replace(SCENE_ID_PLACEHOLDER, sceneId);
            this.etcdKVClientDelegate.deleteWithPrefix(prefix);
        }
        catch (Exception e) {
            log.error("\u6e05\u9664etcd\u573a\u666f\u538b\u6d4b\u8db3\u8ff9\u5f02\u5e38\uff0csceneId={}", (Object)sceneId, (Object)e);
        }
    }

    public Map<String, String> getMarks(String sceneId) {
        if (StringUtils.isBlank((String)sceneId)) {
            return Collections.emptyMap();
        }
        try {
            String prefix = PERF_TEST_PREFIX.replace(SCENE_ID_PLACEHOLDER, sceneId);
            return this.etcdKVClientDelegate.getWithPrefix(prefix);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6etcd\u573a\u666f\u538b\u6d4b\u8db3\u8ff9\u5f02\u5e38\uff0csceneId={}", (Object)sceneId, (Object)e);
            return Collections.emptyMap();
        }
    }
}

