/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;

@Aspect
public class PerfTestRedisCachePlugin {
    private static final Logger log = LoggerFactory.getLogger(PerfTestRedisCachePlugin.class);
    @Resource
    private PerfTestFootMarker perfTestFootMarker;
    private Map<RedisClient, String> jedisHostMap = new ConcurrentHashMap<RedisClient, String>();

    @Around(value="execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        RedisClient redisClient = (RedisClient)joinPoint.getTarget();
        String host = this.getHosts(redisClient);
        if (StringUtils.isNotBlank((CharSequence)host)) {
            this.perfTestFootMarker.markRedis(host);
        }
        return joinPoint.proceed();
    }

    private String getHosts(RedisClient redisClient) {
        String jedisHost = this.jedisHostMap.get(redisClient);
        if (StringUtils.isNotBlank((CharSequence)jedisHost)) {
            return jedisHost;
        }
        String newJedisHost = this.getNewJedisHost(redisClient);
        if (StringUtils.isBlank((CharSequence)newJedisHost)) {
            return null;
        }
        String jedisHostTemp = this.jedisHostMap.putIfAbsent(redisClient, newJedisHost);
        if (jedisHostTemp != null) {
            newJedisHost = jedisHostTemp;
        }
        return newJedisHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewJedisHost(RedisClient redisClient) {
        try (Jedis jedis = null;){
            Class<?> redisClientClass = redisClient.getClass();
            Method method = redisClientClass.getDeclaredMethod("getResource", new Class[0]);
            method.setAccessible(true);
            jedis = (Jedis)method.invoke((Object)redisClient, new Object[0]);
            if (jedis == null) {
                String string = null;
                return string;
            }
            Client client = jedis.getClient();
            String string = client != null ? client.getHost() : null;
            return string;
        }
        return null;
    }
}

