/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo;

import cn.com.duibaboot.ext.autoconfigure.cat.context.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider", "consumer"}, order=-9000)
public class DubboCatTransaction
implements Filter {
    private static final ThreadLocal<Cat.Context> CAT_CONTEXT = new ThreadLocal();

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        if (!CatInstance.isEnable()) {
            return invoker.invoke(invocation);
        }
        if (invoker.getInterface().equals(MetadataService.class)) {
            return invoker.invoke(invocation);
        }
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        String loggerName = invoker.getInterface().getSimpleName() + "." + invocation.getMethodName();
        String type = "PigeonCall";
        if ("provider".equals(sideKey)) {
            type = "PigeonService";
        }
        Transaction transaction = Cat.newTransaction((String)type, (String)loggerName);
        try {
            Cat.Context context = this.getContext();
            if ("consumer".equals(sideKey)) {
                this.createConsumerCross(url, transaction);
                Cat.logRemoteCallClient((Cat.Context)context);
            } else {
                this.createProviderCross(transaction);
                Cat.logRemoteCallServer((Cat.Context)context);
            }
            this.setAttachment(context);
            result = invoker.invoke(invocation);
            if (result.hasException()) {
                transaction.setStatus(result.getException());
            } else {
                transaction.setStatus("0");
            }
        }
        catch (Exception e) {
            if (e instanceof RpcException && e.getCause() != null && e.getCause() instanceof InterruptedException) {
                transaction.setStatus(e.getClass().getSimpleName() + ":Caused By:InterruptedException");
            } else {
                transaction.setStatus((Throwable)e);
            }
            throw e;
        }
        finally {
            transaction.complete();
            this.clearContext();
        }
        return result;
    }

    private String getProviderAppName(URL url) {
        String appName = url.getParameter("serverApplicationName");
        if (StringUtils.isEmpty((String)appName)) {
            String interfaceName = url.getParameter("interface");
            appName = interfaceName.substring(0, interfaceName.lastIndexOf(46));
        }
        return appName;
    }

    private void setAttachment(Cat.Context context) {
        RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
        RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
        RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
    }

    private Cat.Context getContext() {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = this.initContext();
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    public void clearContext() {
        CAT_CONTEXT.remove();
    }

    private Cat.Context initContext() {
        DubboCatContext context = new DubboCatContext();
        Map attachments = RpcContext.getContext().getAttachments();
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry entry : attachments.entrySet()) {
                if (!"_catChildMessageId".equals(entry.getKey()) && !"_catRootMessageId".equals(entry.getKey()) && !"_catParentMessageId".equals(entry.getKey())) continue;
                context.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return context;
    }

    private void createConsumerCross(URL url, Transaction transaction) {
        Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)this.getProviderAppName(url));
        Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)url.getHost());
        Event crossPortEvent = Cat.newEvent((String)"PigeonCall.port", (String)(url.getPort() + ""));
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        crossPortEvent.setStatus("0");
        this.completeEvent(crossAppEvent);
        this.completeEvent(crossPortEvent);
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossPortEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    private void createProviderCross(Transaction transaction) {
        String consumerAppName = RpcContext.getContext().getAttachment("application");
        if (StringUtils.isEmpty((String)consumerAppName)) {
            consumerAppName = RpcContext.getContext().getRemoteHost() + ":" + RpcContext.getContext().getRemotePort();
        }
        Event crossAppEvent = Cat.newEvent((String)"PigeonService.app", (String)consumerAppName);
        Event crossServerEvent = Cat.newEvent((String)"PigeonService.client", (String)RpcContext.getContext().getRemoteHost());
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        this.completeEvent(crossAppEvent);
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    private void completeEvent(Event event) {
        AbstractMessage message = (AbstractMessage)event;
        message.setCompleted(true);
    }

    static class DubboCatContext
    implements Cat.Context {
        private Map<String, String> properties = new HashMap<String, String>();

        DubboCatContext() {
        }

        public void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }
    }
}

