/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.springframework.beans.BeanUtils;

@Activate(group={"consumer"}, order=-10002)
public class DubboHystrixFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invoker.getInterface().equals(MetadataService.class)) {
            return invoker.invoke(invocation);
        }
        String remoteApplicationName = invoker.getUrl().getRemoteApplication();
        String methodSignature = DubboHystrixFilter.configKey(invoker.getInterface(), invocation.getMethodName(), invocation.getParameterTypes());
        DubboHystrixCommand dubboHystrixCommand = new DubboHystrixCommand(invoker, invocation, remoteApplicationName, methodSignature);
        try {
            return (Result)dubboHystrixCommand.execute();
        }
        catch (HystrixBadRequestException e) {
            if (e.getCause() != null && e.getCause() instanceof RpcException) {
                throw (RpcException)e.getCause();
            }
            throw e;
        }
    }

    private static String configKey(Class targetType, String methodName, Class<?>[] parameterTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(targetType.getSimpleName());
        builder.append('#').append(methodName).append('(');
        for (Class<?> param : parameterTypes) {
            builder.append(param.getSimpleName()).append(',');
        }
        if (parameterTypes.length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    private static class DubboHystrixCommand
    extends HystrixCommand<Result> {
        private RpcContext rpcContext;
        private Invoker<?> invoker;
        private Invocation invocation;

        protected DubboHystrixCommand(Invoker<?> invoker, Invocation invocation, String group, String command) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)group)).andCommandKey(HystrixCommandKey.Factory.asKey((String)command)));
            this.invoker = invoker;
            this.invocation = invocation;
            this.rpcContext = RpcContext.getServiceContext();
        }

        protected Result run() throws Exception {
            try {
                BeanUtils.copyProperties((Object)this.rpcContext, (Object)RpcContext.getServiceContext());
                Result result = this.invoker.invoke(this.invocation);
                return result;
            }
            catch (RpcException e) {
                throw new HystrixBadRequestException(e.getMessage(), (Throwable)e);
            }
            finally {
                BeanUtils.copyProperties((Object)RpcContext.getServiceContext(), (Object)this.rpcContext);
                RpcContext.removeContext();
            }
        }
    }
}

