/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.client;

import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.exception.EtcdOperationException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class RestEtcdKVClientDelegate
implements EtcdKVClientDelegate {
    private static final Logger logger = LoggerFactory.getLogger(RestEtcdKVClientDelegate.class);
    private RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofMillis(5000L)).setReadTimeout(Duration.ofMillis(5000L)).build();
    private String[] etcdUris;
    private String curApiVersion = "/v3alpha";
    private static final String[] API_VERSIONS = new String[]{"/v3", "/v3alpha", "/v3beta"};
    private static final int MAX_RETRY_TIMES = 2;

    public RestEtcdKVClientDelegate(String ... etcdUris) {
        this.etcdUris = etcdUris;
        if (etcdUris == null || etcdUris.length == 0) {
            throw new IllegalArgumentException("etcdUris must not be empty");
        }
        for (String apiVersion : API_VERSIONS) {
            for (String etcdUri : etcdUris) {
                try {
                    ResponseEntity resp = this.restTemplate.postForEntity(etcdUri + apiVersion + "/kv/range", (Object)"{\"key\": \"Zm9v\"}", String.class, new Object[0]);
                    if (resp.getStatusCodeValue() != 200) continue;
                    this.curApiVersion = apiVersion;
                    return;
                }
                catch (Throwable e) {
                    logger.info("", e);
                }
            }
        }
        throw new IllegalStateException("\u65e0\u6cd5\u63a2\u6d4betcd\u7684http api\u7248\u672c\u53f7, etcdUris: " + Arrays.toString(etcdUris));
    }

    @Override
    public void put(String key, String value) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)SecurityUtils.encode2StringByBase64((byte[])key.getBytes()));
        jsonObject.put("value", (Object)SecurityUtils.encode2StringByBase64((byte[])value.getBytes()));
        this.postForObject("/kv/put", jsonObject);
    }

    private JSONObject postForObject(String path, JSONObject jsonBody) {
        for (int i = 0; i <= 2; ++i) {
            try {
                String uri = this.etcdUris[RandomUtils.nextInt((int)0, (int)this.etcdUris.length)];
                String result = (String)this.restTemplate.postForObject(uri + this.curApiVersion + path, (Object)jsonBody.toString(), String.class, new Object[0]);
                JSONObject resultJson = JSON.parseObject((String)result);
                if (resultJson.containsKey((Object)"error")) {
                    throw new EtcdOperationException("\u64cd\u4f5cetcd\u65f6\u53d1\u751f\u9519\u8bef, \u9519\u8bef\u54cd\u5e94\uff1a" + result);
                }
                return resultJson;
            }
            catch (Throwable e) {
                if (i >= 2) {
                    throw new EtcdOperationException("\u64cd\u4f5cetcd\u91cd\u8bd52\u6b21\u540e\u4ecd\u7136\u5931\u8d25", e);
                }
                logger.warn("\u64cd\u4f5cetcd\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5c06\u81ea\u52a8\u91cd\u8bd5,\u7b2c{}/{}\u6b21\u91cd\u8bd5", new Object[]{i + 1, 2, e});
                continue;
            }
        }
        throw new EtcdOperationException("[NOTIFYME]\u64cd\u4f5cetcd\u65f6\u53d1\u751f\u9519\u8bef, \u4e0d\u5e94\u8be5\u8fd0\u884c\u5230\u8fd9\u91cc");
    }

    @Override
    public String get(String key) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)SecurityUtils.encode2StringByBase64((byte[])key.getBytes()));
        JSONObject resultJson = this.postForObject("/kv/range", jsonObject);
        JSONArray arr = resultJson.getJSONArray("kvs");
        if (arr != null && !arr.isEmpty()) {
            JSONObject obj = arr.getJSONObject(0);
            return new String(SecurityUtils.decodeBase64((String)StringUtils.defaultString((String)obj.getString("value"))), Charset.forName("utf-8"));
        }
        return null;
    }

    @Override
    public Map<String, String> getWithPrefix(String prefix) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)SecurityUtils.encode2StringByBase64((byte[])prefix.getBytes()));
        jsonObject.put("range_end", (Object)SecurityUtils.encode2StringByBase64((byte[])this.prefixEndOf(prefix.getBytes())));
        JSONObject resultJson = this.postForObject("/kv/range", jsonObject);
        JSONArray arr = resultJson.getJSONArray("kvs");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (arr != null && !arr.isEmpty()) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String key = new String(SecurityUtils.decodeBase64((String)obj.getString("key")), Charset.forName("utf-8"));
                String value = new String(SecurityUtils.decodeBase64((String)StringUtils.defaultString((String)obj.getString("value"))), Charset.forName("utf-8"));
                map.put(key, value);
            }
        }
        return map;
    }

    @Override
    public void delete(String key) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)SecurityUtils.encode2StringByBase64((byte[])key.getBytes()));
        this.postForObject("/kv/deleterange", jsonObject);
    }

    @Override
    public void deleteWithPrefix(String prefix) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", (Object)SecurityUtils.encode2StringByBase64((byte[])prefix.getBytes()));
        jsonObject.put("range_end", (Object)SecurityUtils.encode2StringByBase64((byte[])this.prefixEndOf(prefix.getBytes())));
        this.postForObject("/kv/deleterange", jsonObject);
    }

    private final byte[] prefixEndOf(byte[] prefix) {
        byte[] endKey = (byte[])prefix.clone();
        for (int i = endKey.length - 1; i >= 0; --i) {
            if (endKey[i] >= 255) continue;
            endKey[i] = (byte)(endKey[i] + 1);
            return Arrays.copyOf(endKey, i + 1);
        }
        return new byte[]{0};
    }

    public static void main(String[] args) {
        RestEtcdKVClientDelegate delegate = new RestEtcdKVClientDelegate("http://172.16.80.120:2379");
        delegate.put("/config1/zuul-server/a", "fuckit");
        delegate.put("/config1/zuul-server/b", "fuckit");
        delegate.put("/config1/zuul-server/c", "fuckit");
        String value = delegate.get("/config1/zuul-server/a");
        System.out.println(value);
        Map<String, String> map = delegate.getWithPrefix("/config1/");
        System.out.println(map);
        delegate.delete("/config1/zuul-server/b");
        delegate.deleteWithPrefix("/config1/zuul-server/");
        map = delegate.getWithPrefix("/config1");
        System.out.println(map);
    }
}

