/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.DubboSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.DuibaSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class BeanPostProcessorOfSpecified
implements BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap = new HashMap<AsyncSpecifiedBeanPostProcessor, Map<String, Object>>(10);
    private List<SpecifiedBeanPostProcessor> processorList;
    private List<AsyncSpecifiedBeanPostProcessor> asyncProcessorList;
    private Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> dubboAsyncProcessor2BeansMap = new HashMap<DubboSpecifiedBeanPostProcessor, Map<String, Object>>(10);
    private List<DubboSpecifiedBeanPostProcessor> dubboAsyncProcessorList;

    public int getOrder() {
        return -2;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for (SpecifiedBeanPostProcessor p : this.processorList) {
            if (!p.getBeanType().isAssignableFrom(bean.getClass())) continue;
            bean = p.postProcessBeforeInitialization(bean, beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for (SpecifiedBeanPostProcessor p : this.processorList) {
            if (!p.getBeanType().isAssignableFrom(bean.getClass())) continue;
            bean = p.postProcessAfterInitialization(bean, beanName);
        }
        this.genSpecifiedBeanMap(bean, beanName, this.asyncProcessorList, this.asyncProcessor2BeansMap);
        this.genSpecifiedBeanMap(bean, beanName, this.dubboAsyncProcessorList, this.dubboAsyncProcessor2BeansMap);
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map processorMap = applicationContext.getBeansOfType(SpecifiedBeanPostProcessor.class, false, false);
        ArrayList processorList = new ArrayList(processorMap.values());
        Collections.sort(processorList, (o1, o2) -> o1.getOrder() - o2.getOrder());
        Map asyncProcessorMap = applicationContext.getBeansOfType(AsyncSpecifiedBeanPostProcessor.class, false, false);
        ArrayList asyncProcessorList = new ArrayList(asyncProcessorMap.values());
        this.processorList = processorList;
        this.asyncProcessorList = asyncProcessorList;
    }

    public Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> getAsyncProcessor2BeansMap() {
        return this.asyncProcessor2BeansMap;
    }

    public Map<DubboSpecifiedBeanPostProcessor, Map<String, Object>> getDubboAsyncProcessor2BeansMap() {
        return this.dubboAsyncProcessor2BeansMap;
    }

    private <T extends DuibaSpecifiedBeanPostProcessor> void genSpecifiedBeanMap(Object bean, String beanName, List<T> specifiedBeanList, Map<T, Map<String, Object>> specifiedBeanMap) {
        for (DuibaSpecifiedBeanPostProcessor t : specifiedBeanList) {
            if (!t.getBeanType().isAssignableFrom(bean.getClass())) continue;
            Map<String, Object> beanMap = specifiedBeanMap.get(t);
            if (beanMap == null) {
                beanMap = new HashMap<String, Object>();
                specifiedBeanMap.put(t, beanMap);
            }
            beanMap.put(beanName, bean);
        }
    }
}

