/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.dbexec.JvmIdTool;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.GcAlerter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class GcMonitor
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcMonitor.class);
    private static final String JSTAT_GC_COMMAND = "jstat -gc %s 5000";
    private volatile JstatThread jstatThread;
    @Autowired
    private List<GcAlerter> gcAlerters;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void init() {
        this.jstatThread = new JstatThread();
        new Thread(this.jstatThread).start();
    }

    public void destroy() throws Exception {
        this.jstatThread.stop();
    }

    private class JstatAlerter {
        private static final int PERIOD_COUNT = 12;
        private static final int QUEUE_MAX_SIZE = 60;
        private volatile Map<String, Integer> columnIndexMap;
        private final AtomicInteger periodCounter = new AtomicInteger(12);
        private final LinkedList<JstatPoint> jstatPointQueue = new LinkedList();

        private JstatAlerter() {
        }

        public void collect(String line) {
            if (StringUtils.isBlank((String)line)) {
                return;
            }
            String[] columns = line.trim().split(" +");
            if (this.columnIndexMap == null && "S0C".equals(columns[0])) {
                HashMap<String, Integer> columnIndexMapTemp = new HashMap<String, Integer>();
                for (int i = 0; i < columns.length; ++i) {
                    columnIndexMapTemp.put(columns[i], i);
                }
                this.columnIndexMap = columnIndexMapTemp;
                return;
            }
            if (this.columnIndexMap == null) {
                return;
            }
            if (this.periodCounter.decrementAndGet() < 1) {
                String fgc = columns[this.columnIndexMap.get("FGC")];
                String fgct = columns[this.columnIndexMap.get("FGCT")];
                String ygc = columns[this.columnIndexMap.get("YGC")];
                String ygct = columns[this.columnIndexMap.get("YGCT")];
                this.jstatPointQueue.offer(new JstatPoint(fgc, fgct, ygc, ygct));
                if (this.jstatPointQueue.size() > 60) {
                    this.jstatPointQueue.poll();
                }
                this.tryAlert();
                this.periodCounter.set(12);
            }
        }

        public void tryAlert() {
            for (GcAlerter alerter : GcMonitor.this.gcAlerters) {
                alerter.run(this.jstatPointQueue);
            }
        }
    }

    private class JstatThread
    implements Runnable {
        private volatile boolean jstatThreadCanceled = false;
        private final JstatAlerter jstatAlerter = new JstatAlerter();

        private JstatThread() {
        }

        @Override
        public void run() {
            Process p;
            String command = String.format(GcMonitor.JSTAT_GC_COMMAND, JvmIdTool.getVmId());
            ProcessBuilder processBuilder = new ProcessBuilder(command.split(" "));
            processBuilder.redirectErrorStream(true);
            try {
                p = processBuilder.start();
            }
            catch (IOException e) {
                LOGGER.warn("jstat\u547d\u4ee4\u542f\u52a8\u5f02\u5e38, gc\u76d1\u63a7\u672a\u542f\u52a8, error={}", (Object)e.getMessage());
                return;
            }
            try (InputStream is = p.getInputStream();
                 BufferedReader bs = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = bs.readLine()) != null) {
                    if (this.jstatThreadCanceled) {
                        break;
                    }
                    this.jstatAlerter.collect(line);
                }
            }
            catch (IOException e) {
                LOGGER.warn("jstat\u547d\u4ee4\u6267\u884c\u5f02\u5e38, gc\u76d1\u63a7\u505c\u6b62, error={}", (Object)e.getMessage());
            }
            LOGGER.info("jstatThread completed!!");
        }

        public void stop() {
            this.jstatThreadCanceled = true;
        }
    }
}

