/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.DuibaJvmMonitorProperties;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JvmAlertComponent;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.GcAlerter;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;

public class FGCTAlerter
extends GcAlerter {
    @Resource
    private DuibaJvmMonitorProperties duibaJvmMonitorProperties;
    @Resource
    private JvmAlertComponent jvmAlertComponent;

    @Override
    public Map<Integer, Integer> getRule() {
        return this.duibaJvmMonitorProperties.getFgctRule();
    }

    @Override
    public int compute(Pair<JstatPoint, JstatPoint> pointPair) {
        JstatPoint left = (JstatPoint)pointPair.getLeft();
        JstatPoint right = (JstatPoint)pointPair.getRight();
        return right.getFgct() - left.getFgct();
    }

    @Override
    public void alert(int ruleMinutes, int ruleValue, int currentValue) {
        String ruleValueStr = new BigDecimal(ruleValue).divide(JstatPoint.MULTIPLE, 3, 4).toString();
        String currentValueStr = new BigDecimal(currentValue).divide(JstatPoint.MULTIPLE, 3, 4).toString();
        this.jvmAlertComponent.doGcAlert(ruleMinutes, ruleValueStr + "\u79d2", currentValueStr + "\u79d2", "FGCT\u8fc7\u957f");
    }
}

