/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.zaxxer.hikari.HikariDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class PerfTestRoutingDataSourceForHikari
extends PerfTestRoutingDataSource<HikariDataSource> {
    private static final Logger log = LoggerFactory.getLogger(PerfTestRoutingDataSourceForHikari.class);

    public PerfTestRoutingDataSourceForHikari(HikariDataSource originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        super(originalDataSource, environment, perfTestFootMarker);
    }

    @Override
    protected String getJdbcUrl(HikariDataSource originalDataSource) {
        return originalDataSource.getJdbcUrl();
    }

    @Override
    protected HikariDataSource copyDataSource(String testUrl, HikariDataSource originalDataSource) {
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setJdbcUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setLeakDetectionThreshold(originalDataSource.getLeakDetectionThreshold());
        ds.setMaximumPoolSize(originalDataSource.getMaximumPoolSize());
        ds.setMaxLifetime(originalDataSource.getMaxLifetime());
        ds.setMinimumIdle(0);
        ds.setIdleTimeout(30000L);
        ds.setValidationTimeout(originalDataSource.getValidationTimeout());
        ds.setConnectionTimeout(originalDataSource.getConnectionTimeout());
        ds.setPoolName(originalDataSource.getPoolName() + "_shade");
        ds.setConnectionInitSql(originalDataSource.getConnectionInitSql());
        return ds;
    }
}

