/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorRunnable;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileRunnable
extends MonitorRunnable {
    private static final Logger logger = LoggerFactory.getLogger(ProfileRunnable.class);
    private String threadPoolName = "undefined";

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue, String threadPoolName, int maxWaitTimeMillis) {
        super(runnable, queue, maxWaitTimeMillis);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public void run() {
        if (CatUtils.isCatEnabled()) {
            DBTimeProfile.start();
            Transaction t = Cat.newTransaction((String)"ThreadPool", (String)this.threadPoolName);
            CatUtils.newCompletedTransaction("ThreadPool", this.threadPoolName + ".queue.wait", this.getSubmitTimeNano());
            try {
                super.run();
                t.setStatus("0");
            }
            catch (Throwable throwable) {
                t.setStatus(throwable);
                if (this.nestOverLimit(throwable)) {
                    throw new RuntimeException("abnormal throwable: \u3010" + throwable.getClass().getName() + "\u3011, stacktrace: \u3010" + ExceptionUtils.getStackTrace((Throwable)throwable) + "\u3011");
                }
                logger.error("", throwable);
                throw Throwables.propagate((Throwable)throwable);
            }
            finally {
                String rootRunnableClassName = this.getRootRunnable().getClass().getName();
                t.addData("method", (Object)rootRunnableClassName);
                t.complete();
                DBTimeProfile.end((String)(rootRunnableClassName + ", thread:" + Thread.currentThread().getName()));
            }
        }
        DBTimeProfile.start();
        try {
            super.run();
        }
        catch (Throwable throwable) {
            if (this.nestOverLimit(throwable)) {
                throw new RuntimeException("abnormal throwable: \u3010" + throwable.getClass().getName() + "\u3011, stacktrace: \u3010" + ExceptionUtils.getStackTrace((Throwable)throwable) + "\u3011");
            }
            logger.error("", throwable);
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            String rootRunnableClassName = this.getRootRunnable().getClass().getName();
            DBTimeProfile.end((String)(rootRunnableClassName + ", thread:" + Thread.currentThread().getName()));
        }
    }

    private boolean nestOverLimit(Throwable t) {
        int nestTime = 0;
        while (t != null) {
            if (nestTime > 20) {
                logger.error("detect abnormal exception:{}, msg={}", (Object)t.getClass().getName(), (Object)t.getMessage());
                return true;
            }
            t = t.getCause();
            ++nestTime;
        }
        return false;
    }
}

