/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.BeansException;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;

public class ZipkinLoadBalancerBeanPostProcessor
implements SpecifiedBeanPostProcessor<ZipkinLoadBalancer> {
    private int zipkinPort;

    public ZipkinLoadBalancerBeanPostProcessor(int zipkinPort) {
        this.zipkinPort = zipkinPort;
    }

    @Override
    public Class<ZipkinLoadBalancer> getBeanType() {
        return ZipkinLoadBalancer.class;
    }

    @Override
    public Object postProcessBeforeInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(ZipkinLoadBalancer bean, String beanName) throws BeansException {
        return new ZipkinLoadBalancerUsingAnotherPort(bean, this.zipkinPort);
    }

    public int getOrder() {
        return 0;
    }

    private static class ZipkinLoadBalancerUsingAnotherPort
    implements ZipkinLoadBalancer {
        private ZipkinLoadBalancer delegate;
        private int zipkinPort;

        public ZipkinLoadBalancerUsingAnotherPort(ZipkinLoadBalancer delegate, int zipkinPort) {
            this.delegate = delegate;
            this.zipkinPort = zipkinPort;
        }

        public URI instance() {
            URI uri = this.delegate.instance();
            if (uri.getPort() != this.zipkinPort) {
                try {
                    uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), this.zipkinPort, uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return uri;
        }
    }
}

