/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheChangeRecord;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorConstant;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.RecordPagerResponse;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehcache.PersistentUserManagedCache;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheEventListenerConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.config.builders.UserManagedCacheConfiguration;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.event.EventType;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.config.persistence.UserManagedPersistenceContext;
import org.ehcache.impl.persistence.DefaultLocalPersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

class CacheMonitorManager {
    private static final Logger log = LoggerFactory.getLogger(CacheMonitorManager.class);
    private static Environment environment;
    private static final String localIp;
    private static String currentAppName;
    private static final ConcurrentMap<Object, String> allCacheMap;
    private static final ConcurrentMap<Integer, Object> cacheBuilderMap;
    private static final ArrayBlockingQueue<CacheChangeRecord> recordQueue;
    private static final ConcurrentMap<String, CopyOnWriteArrayList<Integer>> cachePageUtilMap;
    private static final int pageSize = 30;
    private static boolean isConsuming;
    static volatile boolean isOpenRecord;
    private static PersistentUserManagedCache<String, ArrayList> monitorCache;

    CacheMonitorManager() {
    }

    static void saveCache(Object key, String value) {
        if (key == null) {
            return;
        }
        allCacheMap.put(key, value);
    }

    static Set<String> getAllCache() {
        HashSet names = Sets.newHashSet();
        for (Map.Entry entry : allCacheMap.entrySet()) {
            names.add(entry.getValue());
        }
        return names;
    }

    static Object getCacheValueByKey(String cacheName, String key) {
        Iterator iterator;
        com.google.common.cache.Cache cache;
        Object cacheObj = null;
        for (Map.Entry entry : allCacheMap.entrySet()) {
            if (!((String)entry.getValue()).equals(cacheName)) continue;
            cacheObj = entry.getKey();
            break;
        }
        if (cacheObj == null) {
            return null;
        }
        if (cacheObj instanceof com.google.common.cache.Cache) {
            cache = cacheObj;
            iterator = cache.asMap().keySet().iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Class<?> aClass = iterator.next().getClass();
            return cache.getIfPresent(JSON.parseObject((String)("\"" + key + "\""), aClass));
        }
        if (cacheObj instanceof Cache) {
            cache = cacheObj;
            iterator = cache.asMap().keySet().iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            Class<?> aClass = iterator.next().getClass();
            return cache.getIfPresent(JSON.parseObject((String)("\"" + key + "\""), aClass));
        }
        return null;
    }

    static void clearAllCacheValue() {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return;
        }
        for (Map.Entry entry : allCacheMap.entrySet()) {
            com.google.common.cache.Cache cache;
            Object cacheObj = entry.getKey();
            if (cacheObj instanceof com.google.common.cache.Cache) {
                cache = (com.google.common.cache.Cache)cacheObj;
                cache.invalidateAll();
            }
            if (!(cacheObj instanceof Cache)) continue;
            cache = (Cache)cacheObj;
            cache.invalidateAll();
        }
    }

    static RecordPagerResponse<CacheChangeRecord> getRecord(String cacheName, String key, Integer page) {
        String cacheKey;
        CopyOnWriteArrayList pageUtils;
        if (StringUtils.isBlank((CharSequence)cacheName) || StringUtils.isBlank((CharSequence)key) || monitorCache == null) {
            return null;
        }
        if (page == null) {
            page = 1;
        }
        if ((pageUtils = (CopyOnWriteArrayList)cachePageUtilMap.get(cacheKey = String.format("%s-%s", cacheName, key))) == null) {
            return null;
        }
        Collections.reverse(pageUtils);
        Integer pageIndex = (Integer)pageUtils.get(page - 1);
        String monitorKey = String.format("%s-%s-%s", cacheName, key, pageIndex);
        List values = (List)monitorCache.get((Object)monitorKey);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        Collections.reverse(values);
        int total = (pageUtils.size() - 1) * 30 + values.size();
        return new RecordPagerResponse<CacheChangeRecord>(page, 30, total, values);
    }

    static void setBuilderCache(Integer hashcode, Object value) {
        cacheBuilderMap.put(hashcode, value);
    }

    static void addRecord(CacheChangeRecord record) {
        Object cache = cacheBuilderMap.get(record.getBuilderHashcode());
        if (cache == null) {
            return;
        }
        String cacheName = (String)allCacheMap.get(cache);
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            return;
        }
        record.setCacheName(cacheName);
        recordQueue.offer(record);
    }

    static void init(Environment env, String appName, int httpServerPort) {
        if (env != null) {
            environment = env;
        } else {
            log.warn("\u7f13\u5b58\u76d1\u63a7\u793a\u4f8b\u672a\u521d\u59cb\u5316environment\uff0c\u65e0\u6cd5\u76d1\u63a7\u7f13\u5b58\u7684\u53d8\u5316");
        }
        if (appName != null) {
            currentAppName = appName;
            DefaultLocalPersistenceService persistenceService = new DefaultLocalPersistenceService(new DefaultPersistenceConfiguration(new File(System.getProperty("user.home"), String.format("/cache_monitor/%s/%s", httpServerPort, appName))));
            monitorCache = (PersistentUserManagedCache)UserManagedCacheBuilder.newUserManagedCacheBuilder(String.class, ArrayList.class).withEventExecutors(Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("cache-monitor-ordered", true)), Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("cache-monitor-unordered", true))).withEventListeners(CacheEventListenerConfigurationBuilder.newEventListenerConfiguration(event -> {
                String key = String.valueOf(event.getKey());
                String cacheKey = key.substring(0, key.lastIndexOf("-"));
                Integer curPage = Integer.parseInt(key.substring(key.lastIndexOf("-") + 1));
                CopyOnWriteArrayList pageUtil = (CopyOnWriteArrayList)cachePageUtilMap.get(cacheKey);
                if (pageUtil == null) {
                    return;
                }
                pageUtil.remove(curPage);
                if (pageUtil.size() == 0) {
                    cachePageUtilMap.remove(cacheKey);
                }
            }, (EventType)EventType.REMOVED, (EventType[])new EventType[]{EventType.EVICTED, EventType.EXPIRED}).asynchronous().unordered()).with((UserManagedCacheConfiguration)new UserManagedPersistenceContext("monitorCache", (LocalPersistenceService)persistenceService)).withResourcePools(ResourcePoolsBuilder.newResourcePoolsBuilder().heap(1L, (ResourceUnit)MemoryUnit.MB).disk(100L, MemoryUnit.MB, true)).build(true);
        } else {
            log.warn("\u7f13\u5b58\u76d1\u63a7\u793a\u4f8b\u672a\u521d\u59cb\u5316\u5f53\u524d\u7cfb\u7edf\u540d\u79f0\uff0c\u65e0\u6cd5\u76d1\u63a7\u7f13\u5b58\u7684\u53d8\u5316");
        }
        CacheMonitorManager.changeOpenRecord();
        CacheMonitorManager.startConsume();
    }

    static void changeOpenRecord() {
        if (environment != null && StringUtils.isNotBlank((CharSequence)currentAppName) && isConsuming) {
            String openIp = environment.getProperty(CacheMonitorConstant.RECORD_IP_CONFIG_KEY);
            isOpenRecord = StringUtils.equals((CharSequence)localIp, (CharSequence)openIp);
        }
    }

    private static void startConsume() {
        if (monitorCache == null) {
            return;
        }
        Thread consume = new Thread(() -> {
            while (isConsuming) {
                try {
                    CacheChangeRecord newRecord = recordQueue.take();
                    if (StringUtils.isBlank((CharSequence)newRecord.getCacheName())) continue;
                    String pageKey = CacheMonitorManager.getPageUtilCacheKey(newRecord.getCacheName(), String.valueOf(newRecord.getKey()));
                    CopyOnWriteArrayList pageUtil = (CopyOnWriteArrayList)cachePageUtilMap.get(pageKey);
                    if (pageUtil == null) {
                        pageUtil = Lists.newCopyOnWriteArrayList((Iterable)Lists.newArrayList((Object[])new Integer[]{1}));
                        cachePageUtilMap.put(pageKey, pageUtil);
                    }
                    int curPage = (Integer)pageUtil.get(pageUtil.size() - 1);
                    String monitorKey = CacheMonitorManager.getMonitorCacheKey(newRecord.getCacheName(), String.valueOf(newRecord.getKey()), curPage);
                    ArrayList oldRecords = (ArrayList)monitorCache.get((Object)monitorKey);
                    if (CollectionUtils.isEmpty((Collection)oldRecords)) {
                        oldRecords = Lists.newArrayList();
                        newRecord.buildSerializableObj();
                        oldRecords.add(newRecord);
                        monitorCache.put((Object)monitorKey, (Object)oldRecords);
                        continue;
                    }
                    CacheChangeRecord lastRecord = (CacheChangeRecord)oldRecords.get(oldRecords.size() - 1);
                    if (newRecord.equals(lastRecord)) continue;
                    newRecord.buildSerializableObj();
                    if (oldRecords.size() < 30) {
                        oldRecords.add(newRecord);
                        monitorCache.put((Object)monitorKey, (Object)oldRecords);
                    } else {
                        pageUtil.add(++curPage);
                        monitorKey = CacheMonitorManager.getMonitorCacheKey(newRecord.getCacheName(), String.valueOf(newRecord.getKey()), curPage);
                        monitorCache.put((Object)monitorKey, (Object)Lists.newArrayList((Object[])new CacheChangeRecord[]{newRecord}));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    log.error("\u6d88\u8d39\u7f13\u5b58\u7684\u76d1\u63a7\u5f02\u5e38", throwable);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                isConsuming = false;
            }
        }, "cache-monitor-consume");
        consume.setDaemon(true);
        consume.start();
    }

    private static String getMonitorCacheKey(String cacheName, String key, Integer page) {
        return String.format("%s-%s-%s", cacheName, key, page);
    }

    private static String getPageUtilCacheKey(String cacheName, String key) {
        return String.format("%s-%s", cacheName, key);
    }

    static {
        localIp = NetUtils.getLocalIp();
        allCacheMap = Maps.newConcurrentMap();
        cacheBuilderMap = Maps.newConcurrentMap();
        recordQueue = new ArrayBlockingQueue(1000);
        cachePageUtilMap = Maps.newConcurrentMap();
        isConsuming = true;
        isOpenRecord = false;
        monitorCache = null;
    }
}

