package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class SleuthMongodbPlugin {

    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    /**
     * 拦截MongoOperations类所有接口，记录执行耗时
     *
     * @param joinPoint
     * @return
     * @throws Throwable
     */
    @Around("execution(* org.springframework.data.mongodb.core.MongoOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?> clazz = joinPoint.getTarget().getClass();

        Span curSpan = tracer.currentSpan();
        if(curSpan == null){
            return joinPoint.proceed();
        }

        Span span = tracer.nextSpan().name("mongodb:/"+methodName).kind(Span.Kind.CLIENT)
                .remoteServiceName("Mongodb")
                .start();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getSimpleName()).append(".").append(methodName);
        try(Tracer.SpanInScope scope = tracer.withSpanInScope(span)) {
            if(!span.isNoop()) {
                span.tag("mongodb.class_method", stringBuilder.toString());// get/...
                span.tag("lc", "mongodb");//本地组件名
                span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("thread", Thread.currentThread().getName());
            }
//            span.logEvent(Span.CLIENT_SEND);
            return joinPoint.proceed();
        } catch(Exception e){
            errorParser.error(e, span);
            throw e;
        } finally {
//            span.logEvent(Span.CLIENT_RECV);
            span.finish();
        }

    }
}
