package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import cn.com.duiba.boot.event.ContextClosingEvent;
import cn.com.duibaboot.ext.autoconfigure.graceclose.GracefulCloseRunListener;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import java.util.Map;

/**
 * 修复elasticjob与spring-cloud不兼容的问题，elasticjob过早调用了feign，报出超时问题，这里尝试延迟到容器启动完成后再执行任务
 */
@Configuration
public class ElasticJobFixAutoConfiguration {

    /**
     * elastic job 1.*
     */
    @Configuration
    @ConditionalOnClass(name = "com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler")
    public static class ElasticJob1Configuration {

        @EventListener(WebServerInitializedEvent.class)
        public void onEvent(WebServerInitializedEvent event) {
            DelayedThreadExecutor.startAllTaskThreads();
        }

    }

    @Bean("elasticJobMonitorEndpoint")
    @ConditionalOnClass(name = "io.elasticjob.lite.internal.schedule.JobRegistry")
    @ConditionalOnMissingBean(name = "elasticJobMonitorEndpoint")
    public ElasticJobMonitorEndpointV3 elasticJobMonitorEndpointV3() {
        return new ElasticJobMonitorEndpointV3();
    }

    @Bean("elasticJobMonitorEndpoint")
    @ConditionalOnClass(name = "com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry")
    @ConditionalOnMissingBean(name = "elasticJobMonitorEndpoint")
    public ElasticJobMonitorEndpointV2 elasticJobMonitorEndpointV2() {
        return new ElasticJobMonitorEndpointV2();
    }

    @Configuration
    public static class ElasticJobGracefulCloseConfiguration {
        @EventListener(ContextClosingEvent.class)
        @Order(Ordered.HIGHEST_PRECEDENCE)
        public void onEvent(ContextClosingEvent event) {
            Map<String, ZookeeperRegistryCenter> map = event.getApplicationContext().
                    getBeansOfType(ZookeeperRegistryCenter.class);
            if (map == null || map.isEmpty()) {
                return;
            }
            for (ZookeeperRegistryCenter zookeeperRegistryCenter : map.values()) {
                zookeeperRegistryCenter.close();
            }
            LoggerFactory.getLogger(GracefulCloseRunListener.class).info(
                    "shutdown elasticjob complete");
        }
    }
}
