package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;


/**
 * Plugins finder.
 * Use {@link PluginResourcesResolver} to find all plugins,
 * and ask {@link PluginCfg} to load all plugin definitions.
 *
 */
public class PluginBootstrap {
    private final Logger logger =  LoggerFactory.getLogger(PluginBootstrap.class.getName());

    /**
     * load all plugins.
     *
     * @return plugin definition list.
     */
    public List<AbstractClassEnhancePluginDefine> loadPlugins() {
        PluginResourcesResolver resolver = new PluginResourcesResolver();
        List<URL> resources = resolver.getResources();

        if (resources == null || resources.isEmpty()) {
            logger.info("no plugin files (agent-plugin.def) found, continue to start application.");
            return new ArrayList<>();
        }

        for (URL pluginUrl : resources) {
            try {
                PluginCfg.INSTANCE.load(pluginUrl.openStream());
            } catch (Throwable t) {
                logger.error(String.format("plugin file [%s] init failure.", pluginUrl),t);
            }
        }

        List<PluginDefine> pluginClassList = PluginCfg.INSTANCE.getPluginClassList();

        List<AbstractClassEnhancePluginDefine> plugins = new ArrayList<>();
        for (PluginDefine pluginDefine : pluginClassList) {
            try {
                if(logger.isInfoEnabled()) {
                    logger.info("loading plugin class " + pluginDefine.getDefineClass());
                }

                AbstractClassEnhancePluginDefine plugin =

                    (AbstractClassEnhancePluginDefine) Class.forName(pluginDefine.getDefineClass()).newInstance();
                plugins.add(plugin);
            } catch (Throwable t) {
                logger.error(String.format("load plugin [%s] failure.", pluginDefine.getDefineClass()),t);
            }
        }

        return plugins;

    }

}
