package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by guoyanfei .
 * 2021/6/10 .
 */
public class JvmAlertComponent {

    private static final Logger LOGGER = LoggerFactory.getLogger(JvmAlertComponent.class);

    @Value("${spring.application.name}")
    private String currentAppName;

    private final RestTemplate loadBalancedRestTemplate;

    public JvmAlertComponent(RestTemplate loadBalancedRestTemplate) {
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
    }

    public void doGcAlert(int ruleMinutes, String ruleValue, String currentValue, String msg) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appName", currentAppName);
        paramMap.put("ip", NetUtils.getLocalIp());
        paramMap.put("ruleMinutes", ruleMinutes);
        paramMap.put("ruleValue", ruleValue);
        paramMap.put("currentValue", currentValue);
        paramMap.put("msg", msg);
        paramMap.put("currentTime", DateUtils.getSecondStr(System.currentTimeMillis()));
        try {
            LOGGER.warn("[jvm告警: {}], 最近的{}分钟内，发生: {}, 大于阈值: {}", msg, ruleMinutes, currentValue, ruleValue);
            loadBalancedRestTemplate.postForObject("http://prism/prism/jvmAlert/gcAlert", paramMap, String.class);
        } catch (Exception e) {
            LOGGER.error("GC告警异常, {}", e.getMessage());
        }
    }

    public void doThreadpoolExhaustedReport(String threadPoolName) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appName", currentAppName);
        paramMap.put("ip", NetUtils.getLocalIp());
        paramMap.put("threadPoolName", threadPoolName);
        try {
            LOGGER.warn("[线程池 {} 耗尽], 进行上报", threadPoolName);
            loadBalancedRestTemplate.postForObject("http://prism/prism/jvmAlert/threadpoolExhaustedReport", paramMap, String.class);
        } catch (Exception e) {
            LOGGER.error("线程池耗尽上报异常, {}", e.getMessage());
        }
    }
}
