package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.FGCAlerter;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.FGCTAlerter;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.YGCAlerter;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert.YGCTAlerter;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * jvm监控自动配置
 * Created by guoyanfei .
 * 2021/6/8 .
 */
@Configuration
@ConditionalOnClass({ HttpClient.class, RestTemplate.class })
@EnableConfigurationProperties(DuibaJvmMonitorProperties.class)
public class JvmMonitorAutoConfiguration {

    @Bean
    public GcMonitor gcMonitor() {
        return new GcMonitor();
    }

    @Bean
    public JvmAlertComponent jvmAlertComponent(HttpClient httpClient, List<RestTemplateCustomizer> customizers) {
        RestTemplate loadBalancedRestTemplate = loadBalancedRestTemplate(httpClient);
        for (RestTemplateCustomizer customizer : customizers) {
            customizer.customize(loadBalancedRestTemplate);
        }
        return new JvmAlertComponent(loadBalancedRestTemplate);
    }

    private RestTemplate loadBalancedRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(60000);
        httpRequestFactory.setHttpClient(httpClient);
        RestTemplate template = new RestTemplate(httpRequestFactory);
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        return template;
    }

    @Bean
    @ConditionalOnProperty(value = "duiba.threadpool.enabled", matchIfMissing = false)
    public DuibaThreadpoolExhaustedEventListener duibaThreadpoolExhaustedEventListener() {
        return new DuibaThreadpoolExhaustedEventListener();
    }

    @Configuration
    public static class JvmAlerterConfiguration {



        @Bean
        public FGCAlerter fgcAlerter() {
            return new FGCAlerter();
        }

        @Bean
        public FGCTAlerter fgctAlerter() {
            return new FGCTAlerter();
        }

        @Bean
        public YGCAlerter ygcAlerter() {
            return new YGCAlerter();
        }

        @Bean
        public YGCTAlerter ygctAlerter() {
            return new YGCTAlerter();
        }

    }

}
