package cn.com.duibaboot.ext.autoconfigure.logger;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RunEnvUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 目前一个应用的多个容器可能会调度到同一台物理机上，这会导致多个容器使用同一个日志文件，从而导致冲突，最终只有一个容器能输出日志。为了避免这个问题，覆盖日志路径，往日志路径中加入本机ip.
 */
public class LoggerEnvironmentApplicationInitializer implements EnvironmentPostProcessor {

    private static final String LOGGER_PATH_KEY = "logging.file.path";

    /**
     * 是否在线上环境
     * @return
     */
    private boolean isProdEnv(ConfigurableEnvironment environment){
        String[] activeProfiles = environment.getActiveProfiles();
        for(String p : activeProfiles){
            if(p != null && p.startsWith(SpringEnvironmentUtils.PROD)){
                return true;
            }
        }
        return false;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {

        String appName = environment.getProperty("spring.application.name","application");
        String userHome = environment.getProperty("user.home");

        List<String> pathList = Lists.newArrayList(userHome,"logs",appName);
        //TODO duiba.logger.path.append.ip 这个配置只供临时使用，后续去除；
        //只有线上的容器环境才会往日志路径中附加IP
        if((RunEnvUtils.isRunInDocker() && isProdEnv(environment)) || "true".equals(environment.getProperty("duiba.logger.path.append.ip", "false"))){
            pathList.add(NetUtils.getLocalIp());
        }

        Map<String, Object> map = new HashMap<>();

        map.put(LOGGER_PATH_KEY,String.join("/",pathList));

        PropertySource<?> propertySource = new MapPropertySource("loggingConfig",map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst(propertySource);

    }
}
