package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.endpoint;

import cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan.RpcConsumerScan;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 拉取某个服务RPC接口依赖 Endpoint
 */
@ControllerEndpoint(id = "rpc-consumer")
public class RpcConsumerEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(RpcConsumerEndpoint.class);

    /**
     * 获取单个服务rpc引入信息
     *
     * @param path
     * @return
     */
    @ResponseBody
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{path}"
    )
    public Map<String, Set<String>> invoke(@PathVariable String path) {
        Map<String, Set<String>> allServerRpcMap = RpcConsumerScan.getRpcMonitorInfo();
        if (allServerRpcMap == null) {
            return new HashMap<>();
        }
        if (StringUtils.isBlank(path) || "all".equals(path)) {
            return allServerRpcMap;
        }
        // 如果path是无效的应用，亦返回空
        Map<String, Set<String>> serverRpcMap = new HashMap<>();
        serverRpcMap.put(path, allServerRpcMap.get(path));
        return serverRpcMap;
    }

}
