/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.endpoint;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaClientPushAutoConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 描述: 依赖当前服务的所有应用 Endpoint
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/3/9 15:01
 */
@Endpoint(id = "server-rely")
public class ServerRelyEndpoint {

    @Value("${spring.application.name}")
    private String applicationName;

    @Resource
    private EurekaClientPushAutoConfiguration eurekaClientPushAutoConfiguration;

    /**
     * 获取当前服务rpc接口信息
     *
     * @return
     */
    @ReadOperation
    public Set<String> invoke() {
        Set<String> relyAppNameSet = new HashSet<>();
        String relyAppNames = eurekaClientPushAutoConfiguration.getRelyAppNames();
        if (StringUtils.isBlank(relyAppNames)) {
            return relyAppNameSet;
        }
        relyAppNameSet.addAll(Arrays.stream(relyAppNames.split(",")).collect(Collectors.toSet()));
        relyAppNameSet.remove(applicationName);
        return relyAppNameSet;
    }
}
