/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

/**
 * 描述: rpc 接口扫描
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/2/25 16:25
 */
public class RpcProviderScan {

    private static final Logger LOGGER = LoggerFactory.getLogger(RpcProviderScan.class);

    private static final Set<String> RPC_PROVIDER_CONFIG = new HashSet<>();

    /**
     * 注册rpc的监控数据
     *
     * @param application
     * @param interfaceName
     */
    public synchronized static void registerRpcMonitor(String application, String interfaceName, String applicationName) {
        if (StringUtils.isBlank(application)) {
            return;
        }
        if (!application.equals(applicationName)) {
            return;
        }
        RPC_PROVIDER_CONFIG.add(interfaceName);
    }

    public static Set<String> getRpcMonitorInfo() {
        return RPC_PROVIDER_CONFIG;
    }

}
