package cn.com.duibaboot.ext.autoconfigure.threadpool.properties;

import com.google.common.collect.Maps;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

@ConfigurationProperties(prefix = "duiba.threadpool")
public class DuibaThreadPoolConfig extends ThreadPoolProperties {

    public static final Integer THREAD_MAX_SIZE = 2000;

    private Boolean enabled = false;

    private Map<String,ThreadPoolProperties> extra = Maps.newHashMap();

    private ScheduledThreadPoolProperties scheduled;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, ThreadPoolProperties> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, ThreadPoolProperties> extra) {
        this.extra = extra;
    }

    public ThreadPoolProperties getDefaultThreadPoolProperties(){
        if(extra.containsKey(ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            return extra.get(ThreadPoolProperties.DEFAULT_BEAN_NAME);
        }
        ThreadPoolProperties properties = new ThreadPoolProperties();
        BeanUtils.copyProperties(this,properties);
        return properties;
    }

    public ScheduledThreadPoolProperties getScheduled() {
        return scheduled;
    }

    public void setScheduled(ScheduledThreadPoolProperties scheduled) {
        this.scheduled = scheduled;
    }

    /**
     *
     * @return
     */
    public Integer getMaxSizeCount(){
        Integer count = 0;
        for(ThreadPoolProperties poolProperties:extra.values()){
            count += poolProperties.getMaxSize();
        }
        if(!extra.containsKey(ThreadPoolProperties.DEFAULT_BEAN_NAME)){
            count += this.getMaxSize();
        }
        return count;
    }
}
