/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RunEnvUtils;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import com.google.common.base.Joiner;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class CommonDiscoveryMetadataRegister
implements DiscoveryMetadataRegister {
    private static long serverStartUpTime;
    @Value(value="${duiba.perf.scene.id:}")
    private String duibaPerfSceneId;
    @Value(value="${duiba.service.group.key:}")
    private String duibaServiceGroupKey;
    @Value(value="${zone:defaultZone}")
    private String zone;
    @Value(value="${duiba.warmup.timemillis:300000}")
    private Integer duibaWarmUpTimeMillis;
    @Autowired
    private Environment environment;
    @Resource
    private SpringClientFactory ribbonSpringClientFactory;
    private volatile boolean contextStarted = false;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void onMainContextRefreshed() {
        this.contextStarted = true;
    }

    private synchronized long getServerStartUpTime() {
        if (!this.contextStarted) {
            return System.currentTimeMillis();
        }
        if (serverStartUpTime == 0L) {
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    public static long getServerStartUpTimeOuternal() {
        return serverStartUpTime;
    }

    @Override
    public void registerMetadata(Map<String, String> metadata) {
        long serverStartUpTime = this.getServerStartUpTime();
        metadata.put("serverStartUpTime", String.valueOf(serverStartUpTime));
        metadata.put("duiba.warmup.timemillis", String.valueOf(this.duibaWarmUpTimeMillis));
        metadata.put("weight", String.valueOf(100));
        boolean jarInJarMode = SpringBootUtils.isJarInJarMode();
        metadata.put("runInSingleJarMode", jarInJarMode ? "true" : "false");
        metadata.put("springBootVersion", StringUtils.trimToEmpty((String)SpringBootVersion.getVersion()));
        metadata.put("duibaBootVersion", StringUtils.trimToEmpty((String)DuibaBootVersion.getVersion()));
        metadata.put("run.in.docker", RunEnvUtils.isRunInDocker() ? "true" : "false");
        if (!StringUtils.isBlank((CharSequence)this.duibaPerfSceneId)) {
            metadata.put("duiba.perf.scene.id", this.duibaPerfSceneId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.duibaServiceGroupKey)) {
            metadata.put("duiba.service.group.key", this.duibaServiceGroupKey);
        } else if (!RunEnvUtils.isRunInDocker()) {
            metadata.put("duiba.service.group.key", "dev_ip_" + NetUtils.getLocalIp());
        }
        metadata.put("configVersion", StringUtils.trimToEmpty((String)this.environment.getProperty("config.client.version")));
        metadata.put("zone", StringUtils.trimToEmpty((String)this.zone));
        metadata.put("application.dependents", Joiner.on((String)",").join((Iterable)this.ribbonSpringClientFactory.getContextNames()));
    }
}

