/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceGroupContext {
    private static final Logger log = LoggerFactory.getLogger(ServiceGroupContext.class);
    private String duibaServiceGroupKey;

    private ServiceGroupContext() {
    }

    public static String getCurrentGroupKey() {
        ServiceGroupContext c = (ServiceGroupContext)TransmittableThreadLocalHolder.threadLocal2ServiceGroup.get();
        if (c == null) {
            return null;
        }
        return c.duibaServiceGroupKey;
    }

    public static void setGroupKey(String groupKey) {
        if (StringUtils.isBlank((CharSequence)groupKey)) {
            return;
        }
        ServiceGroupContext c = (ServiceGroupContext)TransmittableThreadLocalHolder.threadLocal2ServiceGroup.get();
        if (c == null) {
            c = new ServiceGroupContext();
        }
        c.duibaServiceGroupKey = groupKey;
        TransmittableThreadLocalHolder.threadLocal2ServiceGroup.set((Object)c);
    }

    public static void removeGroupKey() {
        TransmittableThreadLocalHolder.threadLocal2ServiceGroup.remove();
    }

    private static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<ServiceGroupContext> threadLocal2ServiceGroup = new TransmittableThreadLocal();

        private TransmittableThreadLocalHolder() {
        }
    }
}

