/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

class HttpClientHeaderMethodInterceptor
implements HttpClientMethodInterceptor {
    HttpClientHeaderMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args;
        if (!"execute".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        HttpRequest request = null;
        for (Object arg : args = invocation.getArguments()) {
            if (!(arg instanceof HttpRequest)) continue;
            request = (HttpRequest)arg;
            break;
        }
        if (request == null) {
            return invocation.proceed();
        }
        Header[] headers = request.getHeaders("X-Rpc");
        if (headers != null && headers.length > 0 && "true".equals(headers[0].getValue())) {
            return invocation.proceed();
        }
        this.putHeader(request);
        return invocation.proceed();
    }

    private void putHeader(HttpRequest request) {
        HashMap<String, Object> extHeaderMap = new HashMap<String, Object>();
        this.addServiceGroupHeader(extHeaderMap);
        this.addPerfTestHeader(extHeaderMap);
        if (extHeaderMap.isEmpty()) {
            return;
        }
        extHeaderMap.forEach((k, v) -> {
            if (v != null) {
                request.addHeader(k, v.toString());
            }
        });
    }

    private void addServiceGroupHeader(Map<String, Object> extHeaderMap) {
        String currentGroupKey = ServiceGroupContext.getCurrentGroupKey();
        if (currentGroupKey == null) {
            return;
        }
        extHeaderMap.put("_duibaServiceGroupKey", ServiceGroupContext.getCurrentGroupKey());
    }

    private void addPerfTestHeader(Map<String, Object> extHeaderMap) {
        boolean currentInPerfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        if (!currentInPerfTestMode) {
            return;
        }
        extHeaderMap.put("_duibaPerf", InternalPerfTestContext.isCurrentInPerfTestMode());
        extHeaderMap.put("_duibaPerfSceneId", InternalPerfTestContext.getCurrentSceneId());
        extHeaderMap.put("_duibaPerfTestCluster", InternalPerfTestContext.isTestCluster());
    }

    public int getOrder() {
        return 0;
    }
}

