/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class BodyWriterHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final int BUFFER_SIZE_THRESHOLD = 0xA00000;
    private final HttpServletResponse response;
    private final ByteArrayOutputStream buffer;
    private ServletOutputStream servletOutputStream;
    private PrintWriter printWriter;
    private boolean bufferTooLargeReset = false;

    public BodyWriterHttpServletResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
        this.response = response;
        this.buffer = new ByteArrayOutputStream();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new BodyWriterServletOutputStream(this.buffer, this.response.getOutputStream());
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.printWriter = new BodyWriterPrintWriter(this.buffer, this.response.getWriter(), this.getCharacterEncoding());
        }
        return this.printWriter;
    }

    public void flushBuffer() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        super.flushBuffer();
    }

    public void reset() {
        this.buffer.reset();
        super.reset();
    }

    public byte[] getResponseBody() throws IOException {
        this.flushBuffer();
        return this.buffer.toByteArray();
    }

    private boolean isBufferTooLarge(ByteArrayOutputStream buffer, int currentLength) {
        return buffer.size() + currentLength >= 0xA00000;
    }

    public void bufferTooLargeReset() {
        this.bufferTooLargeReset = true;
        this.buffer.reset();
    }

    public boolean isBufferTooLargeReset() {
        return this.bufferTooLargeReset;
    }

    class BodyWriterServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream buffer;
        private ServletOutputStream out;

        BodyWriterServletOutputStream(ByteArrayOutputStream buffer, ServletOutputStream out) {
            this.buffer = buffer;
            this.out = out;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, 4)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.buffer.write(b);
            }
        }

        public void write(@NotNull byte[] b) throws IOException {
            this.out.write(b);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, b.length)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.buffer.write(b);
            }
        }

        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, len)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.buffer.write(b, off, len);
            }
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }

        public boolean isReady() {
            return this.out.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.out.setWriteListener(writeListener);
        }
    }

    class BodyWriterPrintWriter
    extends PrintWriter {
        private PrintWriter bufferWriter;
        private ByteArrayOutputStream buffer;

        BodyWriterPrintWriter(@NotNull ByteArrayOutputStream buffer, Writer out, String characterEncoding) throws UnsupportedEncodingException {
            super(out);
            this.buffer = buffer;
            this.bufferWriter = new PrintWriter(new OutputStreamWriter((OutputStream)buffer, characterEncoding));
        }

        @Override
        public void write(int c) {
            super.write(c);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, 4)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.bufferWriter.write(c);
            }
        }

        @Override
        public void write(@NotNull char[] buf, int off, int len) {
            super.write(buf, off, len);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, buf.length * 2)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.bufferWriter.write(buf, off, len);
            }
        }

        @Override
        public void write(@NotNull String s, int off, int len) {
            super.write(s, off, len);
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, s.getBytes().length)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.bufferWriter.write(s, off, len);
            }
        }

        @Override
        public void println() {
            super.println();
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLargeReset()) {
                return;
            }
            if (BodyWriterHttpServletResponseWrapper.this.isBufferTooLarge(this.buffer, 2)) {
                BodyWriterHttpServletResponseWrapper.this.bufferTooLargeReset();
            } else {
                this.bufferWriter.println();
            }
        }

        @Override
        public void flush() {
            super.flush();
            this.bufferWriter.flush();
        }

        @Override
        public void close() {
            super.close();
        }
    }
}

