/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogFilter;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AccessLogReactiveFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
@ConditionalOnResource(resources={"classpath:logback/access-logback.xml"})
@ConditionalOnWebApplication
public class AccessLogAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogAutoConfiguration.class);

    @Bean
    public ApplicationListener accesslogLogbackConfig() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/access-logback.xml").getInputStream());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={LoggerContext.class})
    @ConditionalOnResource(resources={"classpath:logback/access-logback.xml"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class AccessLogReactiveFilterConfiguration {
        @Bean
        @Order(value=100)
        public AccessLogReactiveFilter accessLogReactiveFilter() {
            return new AccessLogReactiveFilter();
        }
    }

    @Configuration
    @ConditionalOnClass(value={LoggerContext.class})
    @ConditionalOnResource(resources={"classpath:logback/access-logback.xml"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class AccessLogServletFilterConfiguration {
        @Bean
        public AccessLogFilter accessLogFilter() {
            return new AccessLogFilter();
        }

        @Bean
        public FilterRegistrationBean acesslogHttpFilterConfigurer(AccessLogFilter accessLogFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)accessLogFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(100);
            return registrationBean;
        }
    }
}

