/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.Span;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthHbasePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthJestElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthMybatisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthSpringDataLettucePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SleuthSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import io.lettuce.core.RedisFuture;
import io.searchbox.client.JestClient;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.elasticsearch.client.transport.TransportClient;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class SleuthAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Connection.class, HTable.class, Span.class, Aspect.class})
    public static class SleuthHbaseConfiguration {
        @Bean
        public SleuthHbasePlugin sleuthHbasePlugin() {
            return new SleuthHbasePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JestClient.class, Span.class, Aspect.class})
    public static class SleuthJestElasticsearchConfiguration {
        @Bean
        public SleuthJestElasticSearchPlugin sleuthJestElasticSearchPlugin() {
            return new SleuthJestElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransportClient.class, ElasticsearchOperations.class, Span.class, Aspect.class})
    public static class SleuthElasticsearchConfiguration {
        @Bean
        public SleuthElasticSearchPlugin sleuthElasticSearchPlugin() {
            return new SleuthElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Span.class, Aspect.class, MongoOperations.class})
    public static class SleuthMongodbConfiguration {
        @Bean
        public SleuthMongodbPlugin sleuthMongodbPlugin() {
            return new SleuthMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, RedisFuture.class, Span.class, Aspect.class})
    public static class SleuthSpringDataLettuceAspectConfiguration {
        @Bean
        public SleuthSpringDataLettucePlugin sleuthSpringDataLettuceAspectPlugin() {
            return new SleuthSpringDataLettucePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthSpringDataRedisAspectConfiguration {
        @Bean
        public SleuthSpringDataRedisPlugin sleuthSpringDataRedisAspectPlugin() {
            return new SleuthSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthRedisPluginConfiguration {
        @Bean
        public SleuthRedisPlugin sleuthRedisPlugin() {
            return new SleuthRedisPlugin();
        }
    }

    private static class SleuthMybatisBeanPostProcessor
    implements SpecifiedBeanPostProcessor<Object>,
    BeanFactoryAware {
        private BeanFactory beanFactory;
        private volatile SleuthMybatisPlugin sleuthMybatisPlugin;

        private SleuthMybatisBeanPostProcessor() {
        }

        private SleuthMybatisPlugin getSleuthMybatisPlugin() {
            if (this.sleuthMybatisPlugin == null) {
                this.sleuthMybatisPlugin = (SleuthMybatisPlugin)this.beanFactory.getBean(SleuthMybatisPlugin.class);
            }
            return this.sleuthMybatisPlugin;
        }

        public int getOrder() {
            return -1;
        }

        @Override
        public Class<Object> getBeanType() {
            return Object.class;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            SqlSessionFactory s = null;
            if (bean instanceof SqlSessionFactory) {
                s = (SqlSessionFactory)bean;
            }
            if (bean instanceof SqlSessionTemplate) {
                s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
            }
            if (s == null) {
                return bean;
            }
            this.addInterceptor(s);
            return bean;
        }

        private void addInterceptor(SqlSessionFactory s) {
            boolean hasCatPlugin = false;
            if (!CollectionUtils.isEmpty((Collection)s.getConfiguration().getInterceptors())) {
                for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                    if (!(plugin instanceof SleuthMybatisPlugin)) continue;
                    hasCatPlugin = true;
                    break;
                }
            }
            if (!hasCatPlugin && this.getSleuthMybatisPlugin() != null) {
                s.getConfiguration().addInterceptor((Interceptor)this.getSleuthMybatisPlugin());
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, Span.class})
    public static class SleuthMyBatisPostProcessorConfiguration {
        @Bean
        public SleuthMybatisPlugin sleuthMybatisPlugin() {
            return new SleuthMybatisPlugin();
        }

        @Bean
        public static SpecifiedBeanPostProcessor sleuthMyBatisPostProcessorConfigurer() {
            return new SleuthMybatisBeanPostProcessor();
        }
    }
}

