/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix.ThreadSafeHystrixMetricsStreamServlet;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import java.lang.reflect.Field;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.web.EndpointServlet;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;

public class HystrixStreamEndpointPostProcessor
implements SpecifiedBeanPostProcessor<HystrixStreamEndpoint> {
    @Override
    public Class<HystrixStreamEndpoint> getBeanType() {
        return HystrixStreamEndpoint.class;
    }

    @Override
    public Object postProcessBeforeInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)bean);
        factory.addAdvice((Advice)new HystrixStreamEndpointMethodInterceptor());
        return factory.getProxy();
    }

    public int getOrder() {
        return 0;
    }

    static class HystrixStreamEndpointMethodInterceptor
    implements MethodInterceptor {
        HystrixStreamEndpointMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("get")) {
                HystrixStreamEndpoint e = (HystrixStreamEndpoint)invocation.getThis();
                Field field = HystrixStreamEndpoint.class.getDeclaredField("initParameters");
                field.setAccessible(true);
                Map initParameters = (Map)field.get(e);
                return new EndpointServlet(ThreadSafeHystrixMetricsStreamServlet.class).withInitParameters(initParameters);
            }
            return invocation.proceed();
        }
    }
}

