/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.wrapper;

import cn.com.duiba.boot.exception.DuibaBootRuntimeException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class BodyReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public BodyReaderHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        try {
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new DuibaBootRuntimeException((Throwable)e);
        }
    }

    public ServletInputStream getInputStream() {
        return new BodyReaderServletInputStream(this.body);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new StringReader(this.getBody()));
    }

    public String getBody() {
        return new String(this.body, Charset.forName("utf-8"));
    }

    class BodyReaderServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream byteArrayInputStream;

        BodyReaderServletInputStream(byte[] body) {
            this.byteArrayInputStream = new ByteArrayInputStream(body);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() {
            return this.byteArrayInputStream.read();
        }
    }
}

