package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config;

import lombok.Getter;
import lombok.Setter;

import java.util.Properties;

/**
 * 数据库加密 - 加密器的配置
 * Created by gyf .
 * 2020/7/28 .
 */
@Getter
@Setter
public final class DBEncryptorRule {

    /**
     * 加密器的算法，比如AES
     * duiba.db.encrypt.encryptors.${加密器名称}.type=AES
     */
    private String type;

    /**
     * 加密器相关的属性，比如密码
     * duiba.db.encrypt.encryptors.${加密器名称}.props.aes.key.value=123345
     */
    private Properties props = new Properties();

}
